<?php

/* Load WordPress engine */
$wp_root_path = dirname(__FILE__, 5);
$wpLoadPath   = $wp_root_path . '/wp-load.php';
if (!file_exists($wpLoadPath)) {
    /** Compatibility with BedRock*/
    $wpLoadPath = $wp_root_path . '/wp/wp-load.php';
}
require($wpLoadPath);

/* Load translations */
load_textdomain( 'woocommerce-dpdfrance', basename( __DIR__ ) . '/../../languages/plugins/' );

class AjaxDPD {
	/**
	 * Return Html template for searched pickup points
	 *
	 * @param $dpd_relais_points
	 *
	 * @return string
	 */
	public static function get_new_searched_pickup_points( $dpd_relais_points ): string {
		$html = '';

		if ( !empty( $dpd_relais_points['error'] ) ) {
			$html .= '<div class="dpdfrance_relais_error">' . $dpd_relais_points['error'] . '</div>';
		} else {
			$html .= '	<script type="text/javascript">
                        	if (typeof relais_data != "undefined") {
                        	    $("#" + relais_data.relay_id).click();                            
                        	}
                        </script>';
			$html .= '<div id="dpdfrance_relais_filter" onclick="
                        var i = 0;
                        for (i=0; i < 6; i++) {
                            document.getElementById(\'dpdfrance_relais_filter\').style.display=\'none\';
                            document.getElementById(\'dpdfrance_relaydetail\'+i).style.display=\'none\';
                        }"></div>
                        <table align="center" id="dpdfrance_relais_point_table" class="dpdfrance_relaistable">';

			$html .= '  <tr>
                            <td colspan="2" style="padding:0px;" class="dpdfrance_headertd">
                                <div id="dpdfrance_div_relais_header">
                                	<p>' . __( 'Please select your DPD Pickup point among this list', 'woocommerce-dpdfrance' ) . '</p>
                                </div>
                                <div id="dpdfrance_div_relais_srch_link">
                                	<span onMouseOver="javascript:this.style.cursor=\'pointer\';javascript:this.style.textDecoration=\'underline\';" onMouseOut="javascript:this.style.cursor=\'auto\';javascript:this.style.textDecoration=\'none\';" onClick="$(\'#dpdfrance_div_relais_srch_panel\').slideToggle();">' . __( 'Search for Pickup points near another address', 'woocommerce-dpdfrance' ) . '</span>
                                	<div id="dpdfrance_div_relais_srch_panel" style="display:none;">
                                	    <input type="text" id="dpdfrance_search_address" placeholder="' . __( 'Address', 'woocommerce-dpdfrance' ) . '" /><br/>
                                	    <input type="text" id="dpdfrance_search_zipcode" maxlength="5" placeholder="' . __( 'Postcode', 'woocommerce-dpdfrance' ) . '" /> 
                                        <input type="text" id="dpdfrance_search_city" placeholder="' . __( 'City', 'woocommerce-dpdfrance' ) . '" />
                                	    <div id="dpdfrance_search_buttons">
                                	        <button type="button" id="dpdfrance_search_submit" name="dpdfrance_search_submit" onclick="dpdfrance_relais_ajaxupdate($(\'#dpdfrance_search_address\').val(), $(\'#dpdfrance_search_zipcode\').val(), $(\'#dpdfrance_search_city\').val(), \'search\');">' . __( 'Search', 'woocommerce-dpdfrance' ) . '</button>
                                	        <button type="button" id="dpdfrance_reset_submit" name="dpdfrance_reset_submit" onclick="dpdfrance_relais_ajaxupdate($(\'#billing_address_1\').val(), $(\'#billing_postcode\').val(), $(\'#billing_city\').val(), \'reset\');">' . __( 'Reset', 'woocommerce-dpdfrance' ) . '</button>
                                	    </div>
                                	</div>
                                </div>
                            </td>
                       </tr>';
			if ( !empty( $dpd_relais_points['empty'] ) ) {
				$html .= '	<tr>
								<td colspan="2" style="padding:0px;" class="dpdfrance_headertd">
									<div class="dpdfrance_relais_error">
										' . $dpd_relais_points['empty'] . '
									</div>
								</td>
							</tr>';
			} else {
				foreach ( $dpd_relais_points as $key => $item ) {
					$html .= '
                			<tr>
                				<td colspan="2" class="dpdfrance_tdpr">
                			    	<div class="dpdfrance_lignepr" onclick="dpdWriteRelaisValues(document.getElementById(\'' . $item['relay_id'] . '\')); document.getElementById(\'' . $item['relay_id'] . '\').checked=true">
                			    	    <div align="left" class="dpdfrance_logorelais"></div>
                			    	    <div align="left" class="dpdfrance_adressepr">
                			    	    	<b>' . $item['shop_name'] . '</b><br/>' . $item['address1'] . '<br/>' . $item['postal_code'] . ' ' . $item['city'] . '<br/>
                			    	    </div>
                			    	    <div align="right" class="dpdfrance_distancepr">' . $item['distance'] . ' km</div>
                			    	    <div align="center" class="dpdfrance_popinpr">
                			    	        <a href="#!" onClick="openDpdfranceDialog(\'' . OS_DPDFRANCE_ROOT_URL . '\',\'dpdfrance_relaydetail' . $key . '\',\'map_canvas' . $key . '\',\'' . $item['coord_lat'] . '\',\'' . $item['coord_long'] . '\')">' . __( 'More details', 'woocommerce-dpdfrance' ) . '</a>
                			    	    </div>
                			    	    <div align="center" class="dpdfrance_radiopr">
                			    	        <input onclick="dpdWriteRelaisValues(document.getElementById(\'' . $item['relay_id'] . '\'))" type="radio" name="dpdfrance_relay_id" id="' . $item['relay_id'] . '" value=\'' . json_encode( $item ) . '\'></input>
                			    	        <label for="' . $item['relay_id'] . '"><span><span></span></span><b>' . __( 'ICI', 'woocommerce-dpdfrance' ) . '</b></label>
                			    	    </div>
                			    	</div>
                				</td>
                			</tr>';

					$html .= '  
								<div class="dpdfrance_relaisbox" id="dpdfrance_relaydetail' . $key . '" style="display:none;">
                                    <div class="dpdfrance_relaisboxclose" onclick="
                                        document.getElementById(\'dpdfrance_relaydetail' . $key . '\').style.display=\'none\';
                                        document.getElementById(\'dpdfrance_relais_filter\').style.display=\'none\'">
                                        <img src="' . OS_DPDFRANCE_ROOT_URL . '/assets/img/front/relais/box-close.png"/>
                        			</div>
                        			<div class="dpdfrrelaisboxcarto" id="map_canvas' . $key . '" style="width:100%;"></div>
                        			<div id="dpdfrrelaisboxbottom" class="dpdfrrelaisboxbottom">
                        				<div id="dpdfrrelaisboxadresse" class="dpdfrrelaisboxadresse">
	                                        <div class="dpdfrrelaisboxadresseheader">
	                                        	<img src="' . OS_DPDFRANCE_ROOT_URL . '/assets/img/front/relais/pointrelais.png" alt="-" width="32" height="32"/><br/>' . __( 'Your DPD Pickup point', 'woocommerce-dpdfrance' ) . '
	                                        </div>
	                                        <strong>' . $item['shop_name'] . '</strong></br>
                        			    ' . $item['address1'] . '</br>';
					if ( !empty( $item['address2'] ) ) {
						$html .= $item['address2'] . '</br>';
					}
					$html .= $item['postal_code'] . '  ' . $item['city'] . '<br/>';
					if ( !empty( $item['local_hint'] ) ) {
						$html .= '<p>' . __( 'Landmark', 'woocommerce-dpdfrance' ) . ' : ' . $item['local_hint'] . '</p>';
					}
					$html .= '  </div>
								<div class="dpdfrrelaisboxhoraires">
                               		<div class="dpdfrrelaisboxhorairesheader"><img src="' . OS_DPDFRANCE_ROOT_URL . '/assets/img/front/relais/horaires.png" alt="-" width="32" height="32"/><br/>' . __( 'Opening Hours', 'woocommerce-dpdfrance' ) . '</div>
                               		<p><span>' . __( 'Monday', 'woocommerce-dpdfrance' ) . ' : </span>' . $item['opening_hours']['monday'] . '</p>
                               		<p><span>' . __( 'Tuesday', 'woocommerce-dpdfrance' ) . ' : </span>' . $item['opening_hours']['tuesday'] . '</p>
                               		<p><span>' . __( 'Wednesday', 'woocommerce-dpdfrance' ) . ' : </span>' . $item['opening_hours']['wednesday'] . '</p>
                               		<p><span>' . __( 'Thursday', 'woocommerce-dpdfrance' ) . ' : </span>' . $item['opening_hours']['thursday'] . '</p>
                               		<p><span>' . __( 'Friday', 'woocommerce-dpdfrance' ) . ' : </span>' . $item['opening_hours']['friday'] . '</p>
                               		<p><span>' . __( 'Saturday', 'woocommerce-dpdfrance' ) . ' : </span>' . $item['opening_hours']['saturday'] . '</p>
                               		<p><span>' . __( 'Sunday', 'woocommerce-dpdfrance' ) . ' : </span>' . $item['opening_hours']['sunday'] . '</p>
                            	</div>
                            	<div class="dpdfrrelaisboxinfos">
                                	<div class="dpdfrrelaisboxinfosheader"><img src="' . OS_DPDFRANCE_ROOT_URL . '/assets/img/front/relais/info.png" alt="-" width="32" height="32"/><br/>' . __( 'More info', 'woocommerce-dpdfrance' ) . '</div>
                                	<div><h5>' . __( 'Distance in KM', 'woocommerce-dpdfrance' ) . ' : </h5><strong>' . $item['distance'] . ' km </strong></div>
                                	<div><h5>' . __( 'DPD Pickup ID#', 'woocommerce-dpdfrance' ) . ' : </h5><strong>' . (string) $item['relay_id'] . '</strong></div>';
					if (
						!empty( $item['closing_period'] ) &&
						count( $item['closing_period'] ) > 0
					) {
						foreach ( $item['closing_period'] as $holiday_item ) {
							$holiday_item = (array) $holiday_item;
							$html         .= '<div><img id="dpdfrrelaisboxinfoswarning" src="' . OS_DPDFRANCE_ROOT_URL . '/assets/img/front/relais/warning.png" alt="-" width="16" height="16"/> <h4>' . __( 'Closing period', 'woocommerce-dpdfrance' ) . ' : </h4> ' . $holiday_item[0] . '</div>';
						}
					}
					$html .= '</div>';

					$html .= '</div></div>'; // dpdfrrelaisboxbottom et relaydetail
				}
			}
			$html .= '</table>';
			$html .= '
					<script type="text/javascript">
                        if (typeof $ === "function" && $("input[name=dpdfrance_relay_id]:checked").length == 0) {
                            $("input[name=dpdfrance_relay_id]").first().click();
                        }
                    </script>';
		}

		/* Display */
		return $html;
	}
}

$dpd_relais_points  = [];
$dpdrelais_settings = get_option( 'woocommerce_dpdfrance_relais_settings' );
$serviceurl         = $dpdrelais_settings['dpdfrance_relais_MyPudoURL'];
$carrier            = $dpdrelais_settings['dpdfrance_relais_MerchantID'];
$key                = $dpdrelais_settings['dpdfrance_relais_SecurityKey'];
$date               = date( 'd/m/Y' );
$address            = WC_DPDFrance_Tools::strip_accents( $_GET['address'] );
$zipcode            = $_GET['zipcode'];
$city               = WC_DPDFrance_Tools::strip_accents( $_GET['city'] );
wc_setcookie( 'dpdfrance_relais_search', $address . "," . $zipcode . "," . $city );

// Zip code is mandatory
if ( empty( $zipcode ) ) {
	$dpd_relais_points['error'] = __( 'Postal code in missing in the address. Please, modify it.', 'woocommerce-dpdfrance' );
	echo $dpd_relais_points;
}

// MyPudo call parameters
$variable      = WC_DPDFrance_Tools::prepare_pudo_query_variable( $carrier, $key, $address, $zipcode, $city, $date );
$get_pudo_list = WC_DPDFrance_Tools::get_pudo_list( $serviceurl, $variable );
// Get the webservice XML response and parse its values
$pudo_list = new SimpleXMLElement( $get_pudo_list );

if ( strlen( $pudo_list->ERROR ) > 0 ) {
	$dpd_relais_points['error'] = __( 'DPD Relais is not available at the moment, please try again shortly.', 'woocommerce-dpdfrance' );
} else {
	$dpd_relais_points = WC_DPDFrance_Tools::get_suggested_pickup_points( $pudo_list, (int)$dpdrelais_settings['pudo_displayed'] );
}

if ( empty( $dpd_relais_points ) ) {
	$dpd_relais_points['empty'] = __( 'There are no Pickup points near this address, please modify it.', 'woocommerce-dpdfrance' );
}

$output = AjaxDPD::get_new_searched_pickup_points( $dpd_relais_points );
echo $output;