/**
 *  ? Generate Selected Option HTML for the table Zone And Rate
 */
let generateSelectOptionsHtml = (options, selected) => {
    let html = null, selectedHtml = null;
    for (const key in options) {
        let value = options[key];

        if (selected instanceof Array) {
            selectedHtml = selected.indexOf(key) !== -1 ? ' selected="selected"' : '';
        } else {
            selectedHtml = key === selected ? ' selected="selected"' : '';
        }

        html += "<option value='" + key + "'" + selectedHtml + ">" + value + "</option>";
    }
    return html;
}

/**
 *  ? Add Row to Table Zone
 */
let addZoneRowHtml = (isNew, rowArr, shippingMethodId) => {
    if (isNew) {
        lastZoneId++;
        rowArr            = [];
        rowArr['id']      = lastZoneId;
        rowArr['name']    = '';
        rowArr['country'] = '';
        rowArr['type']    = 'country';
        rowArr['include'] = '';
        rowArr['exclude'] = '';
        rowArr['enabled'] = '1';
    }
    let tableLength = document.querySelector(`#${shippingMethodId}_zones tbody.zones`).children.length;
    let html = '';
    html     = '<tr class="zone">';
    html    += '   <input type="hidden" name="' + shippingMethodId + '_zone_id[' + tableLength + ']" value="' + rowArr['id'] + '" />';
    html    += '   <input type="hidden" name="' + shippingMethodId + '_zone_type[' + tableLength + ']" value="' + rowArr['type'] + '" />';
    html    += '   <input type="hidden" name="' + shippingMethodId + '_zone_include[' + tableLength + ']" value="' + rowArr['include'] + '" />';
    html    += '   <input type="hidden" name="' + shippingMethodId + '_zone_exclude[' + tableLength + ']" value="' + rowArr['exclude'] + '" />';
    html    += '   <input type="hidden" name="' + shippingMethodId + '_zone_enabled[' + tableLength + ']" value="' + rowArr['enabled'] + '" />';
    html    += '   <th class="check-column">'
    html    += '      <input type="checkbox" name="select"/>';
    html    += '   </th>';
    html    += '   <td>';
    html    += '      <input type="text" name="' + shippingMethodId + '_zone_name[' + tableLength + ']" value="' + rowArr['name'] + '" size="30" placeholder="" />';
    html    += '   </td>';
    html    += '   <td style="overflow:visible;">';
    html    += '      <select multiple="multiple" name="' + shippingMethodId + '_zone_country[' + tableLength + '][]" class="multiselect chosen_select">' + generateSelectOptionsHtml(options['country'], rowArr['country']) + '</select>';
    html    += '   </td>';
    html    += '</tr>';
    return html;
}

/**
 *  ? Add Row to Table Rate
 */
let addTableRateRowHtml = (isNew, rowArr, shippingMethodId, zone = null) =>  {

    if (isNew) {
        lastTableRateId++;
        rowArr            = [];
        rowArr['id']      = lastTableRateId;
        rowArr['zone']    = `${zone}`;
        rowArr['basis']   = 'weight';
        rowArr['min']     = '0';
        rowArr['max']     = '*';
        rowArr['cost']    = '0';
        rowArr['enabled'] = '1';
    }
    let tableLength = document.querySelector(`#${shippingMethodId}_table_rates tbody`).children.length;
    let html        = '';
    html            = '<tr class="table_rate">';
    html            += '   <input type="hidden" name="' + shippingMethodId + '_table_rate_id[' + tableLength + ']" value="' + rowArr['id'] + '" />';
    html            += '   <input type="hidden" name="' + shippingMethodId + '_table_rate_enabled[' + tableLength + ']" value="' + rowArr['enabled'] + '" />';
    html            += '   <th class="check-column">';
    html            += '        <input type="checkbox" name="select" />';
    html            += '   </th>';
    html            += '   <td class="debug-col">' + rowArr['id'] + '</td>';
    html            += '   <td>';
    html            += '       <select name="' + shippingMethodId + '_table_rate_zone[' + tableLength + ']">' + generateSelectOptionsHtml(options['table_rate_zone'], rowArr['zone']) + '</select>';
    html            += '   </td>'
    html            += '   <td>';
    html            += '       <select name="' + shippingMethodId + '_table_rate_basis[' + tableLength + ']">' + generateSelectOptionsHtml(options['rate_basis'], rowArr['basis']) + '</select>';
    html            += '   </td>';
    html            += '   <td>';
    html            += '      <input type="text" name="' + shippingMethodId + '_table_rate_min[' + tableLength + ']" value="' + rowArr['min'] + '" placeholder="0" size="4" />';
    html            += '   </td>';
    html            += '   <td>';
    html            += '      <input type="text" name="' + shippingMethodId + '_table_rate_max[' + tableLength + ']" value="' + rowArr['max'] + '" placeholder="*" size="4" />';
    html            += '   </td>';
    html            += '   <td>';
    html            += '      <input type="text" name="' + shippingMethodId + '_table_rate_cost[' + tableLength + ']" value="' + rowArr['cost'] + '" placeholder="<?php echo wc_format_localized_price( 0 ); ?>" size="4" class="wc_input_price" />';
    html            += '   </td>';
    html            += '</tr>';
    return html;
}

/**
 * ? Print saved datatable
 */
function printSavedDataInTable(array_datas, selectorToHook, datasType, shippingMethodId, datas = null) {
    if (!selectorToHook || !datasType || !shippingMethodId) {
        document.querySelector(`tbody ${selectorToHook}`).innerHTML = "<tr><td>Nous rencontrons actuellement un problème d'affichage de données</td></tr>";
        console.error('DPD France: Something is wrong with the print function to table');
        return;
    }
    array_datas.map(data_row => {
        let data_row_saved = null;
        if (datasType === 'zone') {
            data_row_saved = addZoneRowHtml(false, data_row, shippingMethodId)
        } else if (datasType === 'rate') {
            data_row_saved = addTableRateRowHtml(false, data_row, shippingMethodId, datas)
        } else {
            console.warn('There is no such datatable yet')
        }
        document.querySelector(`tbody ${selectorToHook}`).innerHTML += data_row_saved;

    });
}
