<?php

/* * Exit if accessed directly */
if ( !defined( 'ABSPATH' ) ) {
	exit;
}

/* * Check if WooCommerce is active */
include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
/* * Init plugin */
if ( is_plugin_active( 'woocommerce/woocommerce.php' ) && !class_exists( 'DPDStation' ) ) {
	/* * Main class */

	class DPDStation {
		protected $line;
		protected $contenu_fichier;
		private   $dpd_shipping_method;

		/**
		 * DPDStation constructor.
		 */
		public function __construct() {
			$this->line                = str_pad( '', 2247 );
			$this->contenu_fichier     = '';
			$this->dpd_shipping_method = [ 'dpdfrance_world', 'dpdfrance_classic', 'dpdfrance_relais' ];
		}


		/**
		 * Add limited length content to a given position
		 *
		 * @param $txt
		 * @param $position
		 * @param $txtLength
		 */
		public function add( $txt, $position, $txtLength ) {
			require_once( OS_DPDFRANCE_FILE_PATH . '/classes/class-wc-dpdfrance-tools.php' );

			$formattedText = str_pad( WC_DPDFrance_Tools::strip_accents( $txt ), $txtLength );
			$this->line    = substr_replace( $this->line, $formattedText, $position, $txtLength );
		}

		/**
		 * Add empty line
		 */
		public function add_line() {
			$this->contenu_fichier = $this->contenu_fichier != '' ?
				$this->contenu_fichier . "\r\n" . $this->line :
				$this->contenu_fichier . $this->line;
			$this->line            = str_pad( '', 2247 );
		}


		/**
		 * Download DAT file
		 */
		public function download() {
			while ( @ob_end_clean() ) {}
			header( 'Content-type: application/dat' );
			header( 'Content-Disposition: attachment; filename="DPDFRANCE_' . date( 'dmY-His' ) . '.dat"' );
			echo '$VERSION=110' . "\r\n";
			echo $this->contenu_fichier . "\r\n";
			exit;
		}


		/**
		 * Format order row
		 *
		 * @param $order_infos
		 */
		public function formatRow( $order_infos ) {
            $code_iso                = WC_DPDFrance_Tools::get_iso_code($order_infos);
            $full_name               = $order_infos['shipping_last_name'] . ' ' . $order_infos['shipping_first_name'];
            $shipper_code            = WC_DPDFrance_Tools::get_shipper_code($order_infos);
            $shipping_company        = WC_DPDFrance_Tools::get_company_name($order_infos);
            $parcel_weight           = (string)((int)WC_DPDFrance_Tools::get_converted_parcel_weight_for_export(get_option('woocommerce_weight_unit'), (float)$_POST['poids'][$order_infos['order_id']]));
            $formatted_parcel_weight = str_pad($parcel_weight, 8, '0', STR_PAD_LEFT);
            $mobile                  = WC_DPDFrance_Tools::format_gsm($order_infos['customer_phone'], $code_iso);
            $retour_option           = (int)get_option('wc_settings_tab_dpdfrance_retour_option');                                              // 3: Sur demande, 4: Préparée
            $country_code            = 'F';

			// * Ireland override
			if ( $code_iso === 'IRL' ) {
				$order_infos['shipping_postcode'] = stripos( $order_infos['shipping_city'], 'Dublin' ) !== false ? 1 : 2;
			}

			$this->add( $order_infos['order_id'], 0, 35 );                                                                                  // Référence client N°1
			$this->add( $formatted_parcel_weight, 37, 8 );                                                           // Poids du colis sur 8 caractères
			if ( $order_infos['order_shipping_method_id'] !== 'dpdfrance_relais' ) {
				$this->add( ( $order_infos['shipping_company'] ?: $full_name ), 60, 35 );                                                   // Si Société : Société sinon Nom et Prénom destinataire
				$this->add( ( $order_infos['shipping_company'] ? $full_name : '' ), 95, 35 );                                               // Si Société : Nom et Prénom destinataire, sinon rien
			} else {
				$this->add( $order_infos['shipping_last_name'], 60, 35 );                                                                   // Nom de famille du destinataire
				$this->add( $order_infos['shipping_first_name'], 95, 35 );                                                                  // Prénom du destinataire
			}
			$this->add( $order_infos['shipping_address_2'], 130, 70 );                                                                      // Complément d’adresse 2
			$this->add( $order_infos['shipping_postcode'], 270, 10 );                                                                       // Code postal
			$this->add( $order_infos['shipping_city'], 280, 35 );                                                                           // Ville
			$this->add( $order_infos['shipping_address_1'], 325, 35 );                                                                      // Rue
			$this->add( $code_iso, 370, 3 );                                                                                                // Code Pays destinataire
			$this->add( $order_infos['customer_phone'], 373, 30 );                                                                          // Téléphone Destinataire
			$this->add( get_option( 'wc_settings_tab_dpdfrance_shipper_name' ), 418, 35 );                                                  // Nom expéditeur
			$this->add( get_option( 'wc_settings_tab_dpdfrance_shipper_address2' ), 453, 35 );                                              // Complément d’adresse 1
			$this->add( get_option( 'wc_settings_tab_dpdfrance_shipper_postcode' ), 628, 10 );                                              // Code postal
			$this->add( get_option( 'wc_settings_tab_dpdfrance_shipper_city' ), 638, 35 );                                                  // Ville
			$this->add( get_option( 'wc_settings_tab_dpdfrance_shipper_address1' ), 683, 35 );                                              // Rue
			$this->add( $country_code, 728, 3 );                                                                                            // Code Pays
			$this->add( get_option( 'wc_settings_tab_dpdfrance_shipper_phone' ), 731, 30 );                                                 // Tél. Expéditeur
			$this->add( $order_infos['customer_note'], 761, 140 );                                                                          // Instructions de livraison
			$this->add( date( "d/m/Y" ), 901, 10 );                                                                                         // Date d'expédition théorique
			$this->add( str_pad( $shipper_code, 8, '0', STR_PAD_LEFT ), 911, 8 );                                                           // N° de compte chargeur DPD
			$this->add( $order_infos['order_id'], 919, 35 );                                                                                // Code à barres
			$this->add( $order_infos['order_id'], 954, 35 );                                                                                // N° de commande - Id Order
			if ( isset( $_POST['advalorem'] ) && array_key_exists( $order_infos['order_id'], $_POST['advalorem'] ) ) {                      // Montant valeur colis
				$this->add( str_pad( number_format( $order_infos['order_amount'], 2, '.', '' ), 9, '0', STR_PAD_LEFT ), 1018, 9 );
			}
			$this->add( $order_infos['order_id'], 1035, 35 );                                                                               // Référence client N°2
			$this->add( get_option( 'wc_settings_tab_dpdfrance_shipper_email' ), 1116, 80 );                                                // E-mail expéditeur
			$this->add( get_option( 'wc_settings_tab_dpdfrance_shipper_mobile' ), 1196, 35 );                                               // GSM expéditeur
			$this->add( $order_infos['customer_email'], 1231, 80 );                                                                         // E-mail destinataire
			$this->add( $mobile, 1311, 35 );                                                                                                // GSM destinataire
			if ( $order_infos['order_shipping_method_id'] === 'dpdfrance_relais' ) {
				$this->add( WC_DPDFrance_Tools::get_relais_id( $shipping_company ), 1442, 8 );                            // ID Relais
			}
			if ( !empty( $mobile ) && !in_array( $order_infos['order_shipping_method_id'], $this->dpd_shipping_method, true ) ) {
				$this->add( "+", 1568, 1 );                                                                                                 // Flag Predict
			}
			$this->add( $order_infos['shipping_last_name'], 1569, 35 );                                                                     // Nom de famille du destinataire
			if ( isset( $_POST['retour'] ) && array_key_exists( $order_infos['order_id'], $_POST['retour'] ) && $retour_option !== 0 ) {
				$this->add( $retour_option, 1834, 1 );                                                                                      // Flag Retour
			}

			$this->add_line();
		}
	}
}
