var $ = jQuery.noConflict();
$(document).ready(function () {
    $('.marquee').marquee({
        duration        : 20000,
        gap             : 50,
        delayBeforeStart: 0,
        direction       : 'left',
        duplicated      : true,
        pauseOnHover    : true,
    });
    $('a.popup').fancybox({
        'hideOnContentClick': true,
        'padding'           : 0,
        'overlayColor'      : '#D3D3D3',
        'overlayOpacity'    : 0.7,
        'width'             : 1024,
        'height'            : 640,
        'type'              : 'iframe'
    });
    $.expr[':'].contains = function (a, i, m) {
        return $(a).text().toUpperCase().indexOf(m[3].toUpperCase()) >= 0;
    };

    $("#tableFilter").keyup(function () {
        //split the current value of tableFilter
        var data = this.value.split(";");
        //create a jquery object of the rows
        var jo   = $("#the-list").find("tr");
        if (this.value == "") {
            jo.show();
            return;
        }
        //hide all the rows
        jo.hide();

        //Recursively filter the jquery object to get results.
        jo.filter(function (i, v) {
            var t = $(this);
            for (var d = 0; d < data.length; ++d) {
                if (t.is(":contains('" + data[d] + "')")) {
                    return true;
                }
            }
            return false;
        })
            //show the rows that match.
            .show();
    }).focus(function () {
        this.value = "";
        $(this).css({
            "color": "black"
        });
        $(this).unbind('focus');
    }).css({
        "color": "#C0C0C0"
    });
});

let checkallboxes = (element) => {
    let checkboxes = $("#the-list").find(".checkbox:visible");
    if (element.checked) {
        for (let i = 0; i < checkboxes.length; i++) {
            if (checkboxes[i].type == 'checkbox') {
                checkboxes[i].checked = true;
            }
        }
    } else {
        for (var i = 0; i < checkboxes.length; i++) {
            if (checkboxes[i].type == 'checkbox') {
                checkboxes[i].checked = false;
            }
        }
    }
}

