/**
 * Plugin Name: DPD France
 * Plugin URI: http://www.dpd.fr/ecommerce
 * Description: Module de livraison DPD pour WooCommerce 2 & 3 (France uniquement)
 * Version: 5.3.3
 * Author: DPD France S.A.S.
 * Author URI: http://www.dpd.fr/
 * License: Open Software License (OSL 3.0) - http://opensource.org/licenses/osl-3.0.php
 */

var $ = jQuery.noConflict();

/**
 * Switch state of Place order Button
 */
const switchPlaceOrderButtonEnabled = (enabled) => {
    let placeOrderButton = document.querySelector('button#place_order.button');
    if (typeof enabled !== 'boolean') {
        console.warning('DPD France - Argument on the function switchPlaceOrderButtonEnabled is not boolean');
        switchPlaceOrderButtonEnabled(false);
    }
    if (enabled) {
        placeOrderButton.removeAttribute('disabled');
        placeOrderButton.classList.add('alt');
    } else {
        placeOrderButton.setAttribute("disabled", "disabled");
        placeOrderButton.classList.remove('alt');
    }
}

/**
 * Display Shipping fields in Checkout Page
 */
const displayShippingFields = (enabled) => {
    if (typeof enabled !== 'boolean') {
        console.warning('DPD France - Argument on the function displayShippingFields is not boolean');
        switchPlaceOrderButtonEnabled(false);
    }
    document.querySelector('.woocommerce-shipping-fields').style.display = enabled ? 'block' : 'none';
}

/**
 * Display Shipping form in Checkout Page
 */
const displayShippingAddressForm = (enabled) => {
    if (typeof enabled !== 'boolean') {
        console.warning('DPD France - Argument on the function displayShippingAddressForm is not boolean');
        switchPlaceOrderButtonEnabled(false);
    }
    document.querySelector('.shipping_address').style.display = enabled ? 'block' : 'none';
}

/**
 * Get All shipping methods available
 */
const getShippingMethodList = () => document.querySelectorAll('input[class=shipping_method]');

/**
 * Handle state of the checkbox "Ship to a different address"
 */
const checkShipToDifferentAddress = (value) => {
    if (typeof value !== 'boolean') {
        console.warning('DPD France - Argument on the function checkShipToDifferentAddress is not boolean');
        switchPlaceOrderButtonEnabled(false);
    }
    document.getElementById('ship-to-different-address-checkbox').checked = value;
}

/**
 * Action once the DOM is fully loaded
 */
$(document).ready(() => {
    /**
     * Set the display state of Shipping Fields
     */
    let currentSelectedShippingMethodValue = document.querySelector('input[class=shipping_method]:checked').value;
    displayShippingFields(!(currentSelectedShippingMethodValue === 'dpdfrance_relais'))
});

/**
 * Modify display state of Shipping Field on Shipping method modification event
 */
$(document).on('change', 'input[class=shipping_method]',  (event) => {
    let selectedShippingMethod         = event.currentTarget.value;
    let isSelectedShippingMethodRelais = selectedShippingMethod === 'dpdfrance_relais';
    displayShippingFields(!isSelectedShippingMethodRelais)
});