/**
 * Plugin Name: DPD France
 * Plugin URI: http://www.dpd.fr/ecommerce
 * Description: Module de livraison DPD pour WooCommerce 2 & 3 (France uniquement)
 * Version: 5.3.3
 * Author: DPD France S.A.S.
 * Author URI: http://www.dpd.fr/
 * License: Open Software License (OSL 3.0) - http://opensource.org/licenses/osl-3.0.php
 */

/**
 *  Check phone number input field is allowed for Predict Shipping
 */
const validPhoneNumberPredict = () => {
    let currentSelectedShippingMethodValue = document.querySelector('input[class=shipping_method]:checked').value;
    if (currentSelectedShippingMethodValue !== 'dpdfrance_predict') {
        return false;
    }

    let gsmDest = document.getElementById('billing_phone');
    let gsm_fr  = new RegExp(/^((\+33|0033|0)[67])(?:[ _.-]?(\d{2})){4}$/);
    let gsm_de  = new RegExp(/^(\+|00)49(\s?\d{10,11})$/);
    let gsm_be  = new RegExp(/^(\+|00)32(\s?\d{8,9})$/);
    let gsm_at  = new RegExp(/^(\+|00)43(\s?\d{9,10})$/);
    let gsm_uk  = new RegExp(/^(\+|00)447([3456789]\d)(\s?\d{7})$/);
    let gsm_nl  = new RegExp(/^(\+|00)31(\s?\d{9,10})$/);
    let gsm_pt  = new RegExp(/^(\+|00)351(\s?\d{9,10})$/);
    let gsm_ei  = new RegExp(/^(\+|00)353(\s?\d{8,9})$/);
    let gsm_es  = new RegExp(/^(\+|00)34(\s?\d{9,10})$/);
    let gsm_it  = new RegExp(/^(\+|00)39(\s?\d{8,11})$/);
    let gsm_sw  = new RegExp(/^(\+|00)41(\s?\d{9,10})$/);
    let gsm_hr  = new RegExp(/^(\+|00)385(\s?\d{8,9})$/);
    let gsm_ee  = new RegExp(/^(\+|00)372(\s?\d{7,8})$/);
    let gsm_lt  = new RegExp(/^(\+|00)370(\s?\d{8,9})$/);
    let gsm_pl  = new RegExp(/^(\+|00)48(\s?\d{9,10})$/);
    let gsm_cz  = new RegExp(/^(\+|00)420(\s?\d{9,10})$/);
    let gsm_sk  = new RegExp(/^(\+|00)421(\s?\d{9,10})$/);
    let gsm_si  = new RegExp(/^(\+|00)386(\s?\d{8,9})$/);
    let gsm_lu  = new RegExp(/^(\+|00)352(\s?\d{8,9})$/);
    let gsm_le  = new RegExp(/^(\+|00)371(\s?\d{8,9})$/);
    let gsm_hu  = new RegExp(/^(\+|00)36(\s?\d{8,9})$/);
    let numbers = gsmDest.value.substr(-6);
    let pattern = ['000000', '111111', '222222', '333333', '444444', '555555', '666666', '777777', '888888', '999999', '123456', '234567', '345678', '456789'];
    return (
        gsm_fr.test(gsmDest.value) || gsm_de.test(gsmDest.value) || gsm_be.test(gsmDest.value) || gsm_at.test(gsmDest.value)
        || gsm_uk.test(gsmDest.value) || gsm_nl.test(gsmDest.value) || gsm_pt.test(gsmDest.value) || gsm_ei.test(gsmDest.value)
        || gsm_es.test(gsmDest.value) || gsm_it.test(gsmDest.value) || gsm_sw.test(gsmDest.value) || gsm_hr.test(gsmDest.value)
        || gsm_ee.test(gsmDest.value) || gsm_lt.test(gsmDest.value) || gsm_pl.test(gsmDest.value) || gsm_cz.test(gsmDest.value)
        || gsm_sk.test(gsmDest.value) || gsm_si.test(gsmDest.value) || gsm_lu.test(gsmDest.value) || gsm_le.test(gsmDest.value)
        || gsm_hu.test(gsmDest.value)) && !pattern.includes(numbers);
}

/**
 * Handle the process of selecting Predict Shipping Method
 */
const handleChangeProcessPredict = () => {
    let gsmValidity = $(".gsmValidity");
    if (validPhoneNumberPredict() === true) {
        gsmValidity.html('<td colspan="2"><div class="okmsg" id="dpdfrance_predict_div">{gsm_ok}</div></td>'.replace('{gsm_ok}', objectL10n.gsm_ok));
        switchPlaceOrderButtonEnabled(true);
    } else {
        gsmValidity.html('<td colspan="2"><div class="warnmsg" id="dpdfrance_predict_div">{gsm_ko}</div></td>'.replace('{gsm_ko}', objectL10n.gsm_ko));
        switchPlaceOrderButtonEnabled(false)
    }
}

/**
 * Action once the DOM is fully loaded
 */
$(document).ready(() => {
    let selectedShippingMethod = document.querySelector('input[class=shipping_method]:checked').value;
    if (selectedShippingMethod === 'dpdfrance_predict') {
        handleChangeProcessPredict();
    }
});

/**
 * On key press of the billing phone field, check the phone number validity
 */
document.querySelector('#billing_phone')
        .addEventListener('keyup', () => {
            let selectedShippingMethod = document.querySelector('input[class=shipping_method]:checked').value;
            if (selectedShippingMethod === 'dpdfrance_predict') {
                handleChangeProcessPredict();
            }
        });

/**
 * On Shipping method modification event, Predict is selected, do Predict verification
 */
$(document).on('change', 'input[class=shipping_method]',  (event) => {
    let selectedShippingMethod = event.currentTarget.value;
    if (selectedShippingMethod === 'dpdfrance_predict') {
        handleChangeProcessPredict();
    }
});