<?php

/* * Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/* * Check if WooCommerce is active */
include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
/* * Init plugin */
if ( is_plugin_active( 'woocommerce/woocommerce.php' ) && ! class_exists( 'WC_DPDFrance_Settings_Admin' ) ) {
	/* * Main class */

	class WC_DPDFrance_Settings_Admin {
		/**
		 * [BO][WooCommerce][Reglages][DPD France] Forms Variables for ShipperData Setting
		 * @return array[]
		 */
		public static function settings_admin_shipperdata(): array {
			return [
				'shipper_name'     => [
					'name' => __( 'Company name', 'woocommerce-dpdfrance' ),
					'type' => 'text',
					'css'  => 'width: 400px;',
					'desc' => '',
					'id'   => 'wc_settings_tab_dpdfrance_shipper_name'
				],
				'shipper_address1' => [
					'name' => __( 'Address 1', 'woocommerce-dpdfrance' ),
					'type' => 'text',
					'css'  => 'width: 400px;',
					'desc' => '',
					'id'   => 'wc_settings_tab_dpdfrance_shipper_address1'
				],
				'shipper_address2' => [
					'name' => __( 'Address 2', 'woocommerce-dpdfrance' ),
					'type' => 'text',
					'css'  => 'width: 400px;',
					'desc' => '',
					'id'   => 'wc_settings_tab_dpdfrance_shipper_address2'
				],
				'shipper_postcode' => [
					'name' => __( 'Postal code', 'woocommerce-dpdfrance' ),
					'type' => 'text',
					'css'  => 'width: 400px;',
					'desc' => '',
					'id'   => 'wc_settings_tab_dpdfrance_shipper_postcode'
				],
				'shipper_city'     => [
					'name' => __( 'City', 'woocommerce-dpdfrance' ),
					'type' => 'text',
					'css'  => 'width: 400px;',
					'desc' => '',
					'id'   => 'wc_settings_tab_dpdfrance_shipper_city'
				],
				'shipper_phone'    => [
					'name' => __( 'Telephone number', 'woocommerce-dpdfrance' ),
					'type' => 'text',
					'css'  => 'width: 400px;',
					'desc' => '',
					'id'   => 'wc_settings_tab_dpdfrance_shipper_phone'
				],
				'shipper_mobile'   => [
					'name' => __( 'Mobile phone number', 'woocommerce-dpdfrance' ),
					'type' => 'text',
					'css'  => 'width: 400px;',
					'desc' => '',
					'id'   => 'wc_settings_tab_dpdfrance_shipper_mobile'
				],
				'shipper_email'    => [
					'name' => __( 'E-mail address', 'woocommerce-dpdfrance' ),
					'type' => 'email',
					'css'  => 'width: 400px;',
					'desc' => '',
					'id'   => 'wc_settings_tab_dpdfrance_shipper_email'
				],
			];
		}

		/**
		 * [BO][WooCommerce][Reglages][DPD France] Forms Variables for Shipments Setting
		 * @return array[]
		 */
		public static function settings_admin_shipments(): array {
			return [
				'etape_expedition' => [
					'name'    => __( 'Preparation in progress status', 'woocommerce-dpdfrance' ),
					'type'    => 'select',
					'css'     => 'width: 400px;',
					'options' => wc_get_order_statuses(),
					'desc'    => __( 'Orders in this state will be selected by default for exporting.', 'woocommerce-dpdfrance' ),
					'id'      => 'wc_settings_tab_dpdfrance_etape_expedition',
                    'default' => 'wc-on-hold',
				],
				'etape_expediee'   => [
					'name'    => __( 'Shipped status', 'woocommerce-dpdfrance' ),
					'type'    => 'select',
					'css'     => 'width: 400px;',
					'options' => wc_get_order_statuses(),
					'desc'    => __( 'Once parcel trackings are generated, orders will be updated to this state.', 'woocommerce-dpdfrance' ),
					'id'      => 'wc_settings_tab_dpdfrance_etape_expediee',
                    'default' => 'wc-processing',
                ],
				'etape_livre'      => [
					'name'    => __( 'Delivered status', 'woocommerce-dpdfrance' ),
					'type'    => 'select',
					'css'     => 'width: 400px;',
					'options' => wc_get_order_statuses(),
					'desc'    => __( 'Once parcels are delivered, orders will be updated to this state.', 'woocommerce-dpdfrance' ),
					'id'      => 'wc_settings_tab_dpdfrance_etape_livre',
					'default' => 'wc-completed',
				],
				'auto_update'      => [
					'name'    => __( 'Automatic update of orders', 'woocommerce-dpdfrance' ),
					'type'    => 'select',
					'css'     => 'width: 400px;',
					'options' => [
						0 => __( 'Disabled', 'woocommerce-dpdfrance' ),
						1 => __( 'Enabled', 'woocommerce-dpdfrance' )
					],
					'desc'    => __( 'Order statuses will be automatically updated following parcel delivery status.', 'woocommerce-dpdfrance' ),
					'id'      => 'wc_settings_tab_dpdfrance_auto_update'
				],
				'advalorem_option' => [
					'title'   => __( 'Default insurance service', 'woocommerce-dpdfrance' ),
					'desc'    => __( 'Ad Valorem : Please refer to your pricing conditions.', 'woocommerce-dpdfrance' ),
					'type'    => 'select',
					'css'     => 'width: 400px;',
					'options' => [
						0 => __( 'Integrated parcel insurance service (23 € / kg) - LOTI cdts.', 'woocommerce-dpdfrance' ),
						1 => __( 'Ad Valorem insurance service', 'woocommerce-dpdfrance' )
					],
					'id'      => 'wc_settings_tab_dpdfrance_advalorem_option'
				],
				'retour_option'    => [
					'name'    => __( 'Returns option', 'woocommerce-dpdfrance' ),
					'type'    => 'select',
					'css'     => 'width: 400px;',
					'options' => [
						0 => __( 'No returns', 'woocommerce-dpdfrance' ),
						3 => __( 'On Demand', 'woocommerce-dpdfrance' ),
						4 => __( 'Prepared', 'woocommerce-dpdfrance' )
					],
					'desc'    => __( 'DPD Returns options : Please refer to your pricing conditions.', 'woocommerce-dpdfrance' ),
					'id'      => 'wc_settings_tab_dpdfrance_retour_option'
				],
			];
		}

		/**
		 * [BO][WooCommerce][Reglages][DPD France] Forms Variables for Other Settings
		 * @return array[]
		 */
		public static function settings_admin_googleapi(): array {
			return [
				'google_api_key' => [
					'name' => __( 'Google Maps API Key', 'woocommerce-dpdfrance' ),
					'type' => 'text',
					'css'  => 'width: 400px;',
					'desc' => '<a href="https://console.developers.google.com/flows/enableapi?apiid=maps_backend,geocoding_backend,directions_backend,distance_matrix_backend,elevation_backend,places_backend&keyType=CLIENT_SIDE&reusekey=true" target="_blank">' . __( 'Click here to retrieve your Google API Key', 'woocommerce-dpdfrance' ) . '</a>',
					'id'   => 'wc_settings_tab_dpdfrance_google_api_key'
				],
			];
		}
	}
}
